#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_VbecsUserDivisionRolesCollection
	{
		private VbecsUser _testVbecsUser;
		private VbecsUserDivisionRole _testDivRole;

		[SetUp]
		protected void SetUp()
		{
			_testVbecsUser = new BOL.VbecsUser( Common.LogonUser.LogonUserName );

			_testDivRole = new VbecsUserDivisionRole( new Division( UnitTestConfig.TestDivisionCode ) );
			_testDivRole.Role = new UserRole( COMMON.UserRoleType.AdministratorSupervisor );
		}

		[TearDown]
		protected void TearDown()
		{
			_testVbecsUser = null;
			_testDivRole = null;
		}

		[Test]
		public void Ctor_Empty_Pass()
		{
			VbecsUserDivisionRolesCollection _coll = new VbecsUserDivisionRolesCollection();

			Assert.IsNotNull( _coll );
			Assert.AreEqual( 0, _coll.Count );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Empty_Fail() {}

		[Test]
		public void Ctor_DataTable_Pass()
		{
			DataTable _dt = DAL.VbecsUser.GetVbecsUserDivisionsAndRoles( Common.LogonUser.LogonUserName );
			VbecsUserDivisionRolesCollection _coll = new VbecsUserDivisionRolesCollection( _dt );

			Assert.IsNotNull( _coll );
			Assert.AreEqual( _dt.Rows.Count, _coll.Count );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void Ctor_DataTable_Fail()
		{
			new VbecsUserDivisionRolesCollection( null );
		}

		[Test]
		public void Add_Pass()
		{
			VbecsUserDivisionRolesCollection _coll = new VbecsUserDivisionRolesCollection();
			
			Assert.AreEqual( _testDivRole, _coll.Add( _testDivRole ) );
			Assert.AreEqual( 1, _coll.Count );
			Assert.AreEqual( _testDivRole, _coll[ _testDivRole.Division.DivisionCode ] );
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void Add_Fail_1()
		{
			_testVbecsUser.DivisionsAndRoles.Add( null );
		}

		[Test]
		[ExpectedException( typeof(ArgumentException) )]
		public void Add_Fail_2()
		{
			_testDivRole.Role = null;

			_testVbecsUser.DivisionsAndRoles.Add( _testDivRole );
			_testVbecsUser.DivisionsAndRoles.Add( _testDivRole );
		}

		[Test]
		public void IndexerDivisionCode_Pass()
		{
			Assert.AreEqual( UnitTestConfig.TestDivisionCode.Trim().ToUpper(), _testVbecsUser.DivisionsAndRoles[ UnitTestConfig.TestDivisionCode ].Division.DivisionCode );
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void IndexerDivisionCode_Fail()
		{
			VbecsUserDivisionRole _div = _testVbecsUser.DivisionsAndRoles[ null ];
		}

		[Test]
		public void AllDivisions_Pass()
		{
			Assert.IsNotNull(_testVbecsUser.DivisionsAndRoles.AllDivisions);

			Assert.IsTrue(_testVbecsUser.DivisionsAndRoles.AllDivisions.Count>0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void AllDivisions_Fail() {}

		[Test]
		public void EffectiveDivisions_Pass()
		{
			Assert.IsNotNull( _testVbecsUser.DivisionsAndRoles.EffectiveDivisions );

			Assert.IsTrue( _testVbecsUser.DivisionsAndRoles.EffectiveDivisions.Count > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void EffectiveDivisions_Fail() {}

		[Test]
		public void Count_Pass()
		{
			Assert.IsTrue( _testVbecsUser.DivisionsAndRoles.Count > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Count_Fail() {}

		[Test]
		public void GetEnumerator_Pass()
		{
			IEnumerator _ie = _testVbecsUser.DivisionsAndRoles.GetEnumerator();

			Assert.IsNotNull( _ie );
			Assert.IsTrue( _ie.MoveNext() ); 
			Assert.IsNotNull( _ie.Current );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEnumerator_Fail() {}

		[Test]
		public void IsDirty_Pass()
		{
			_testVbecsUser.DivisionsAndRoles[UnitTestConfig.TestDivisionCode].IsDirty = true;
			//
			Assert.AreEqual(true,_testVbecsUser.DivisionsAndRoles.IsDirty,"IsDirty");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsDirty_Fail()
		{
		}
	}
}

#endif
